
*****************************************************************************
*
*       Apple IIgs Printer Driver data
*
*****************************************************************************

*****************************************************************
*
*       Picter driver data segment
*
*       Written by Matt Deatherage
*       Copyright (C) 1990 Apple Computer, Inc.
*       All rights reserved
*
*****************************************************************

             mcopy picter.macros
             copy  drvrequates.asm
             copy  2/ainclude/e16.control
             copy  2/ainclude/e16.quickdraw
             copy  2/ainclude/e16.print
             copy  2/ainclude/e16.gsos
             copy  2/ainclude/e16.dialog
             copy  2/ainclude/e16.window


PicterData   DATA

OurDP        ds    2                    ; two bytes pre-zeroed storage

;
;  The default print record for our driver
;

DfPRecbase   anop
             dc    i2'OurVersion'

             dc    i2'$8001'            ; interpreted like ImageWriter
             dc    i2'ouriVRes'         ; 36 ppi vertically
             dc    i2'ouriHRes640'      ; 80 ppi horizontally in 640 mode
             dc    i2'0,0,200,640'      ; page rectangle for 640 mode screen

             dc    i2'0,0,200,640'      ; same as rPage for us

             dc    i2'OurwDev'          ; our values for wDev
             ds    8                    ; eight bytes reserved
             dc    i2'paperTypeScreen'  ; default IIgs screen size
             dc    i2'960'              ; for all paper types
             ds    4                    ; four reserved bytes

             ds    14                   ; reserved prInfoPT

             ds    24                   ; reserved prXInfo

             dc    i2'1'                ; iFstPage
             dc    i2'$7FFF'            ; iLstPage
             ds    2                    ; iCopies
             dc    i1'128'              ; default to spool printing
             ds    1                    ; BYTE; wrong in Vol. 1
             dc    i4'0'                ; NIL pointer to background proc
             dc    i4'0'                ; NIL pointer to spool file
             ds    2                    ; iFileVol
             ds    1                    ; bFileVers
             ds    1                    ; bJobX

             ds    38                   ; reserved printX

             ds    2                    ; reserved iReserved

FPrPage640   dc    i2'0,0,378,640'      ; full page rPage
FPrPaper640  dc    i2'-9,-20,387,660'   ; full page rPaper

FPrPage320   dc    i2'0,0,378,320'      ; full page rPage
FPrPaper320  dc    i2'-9,-10,387,330'   ; full page rPaper

SCrPage640   dc    i2'0,0,200,640'
SCrPaper640  dc    i2'0,0,200,640'

SCrPage320   dc    i2'0,0,200,320'
SCrPaper320  dc    i2'0,0,200,320'      ; rPaper = rPage for screen

OpenParams   dc    i2'3'                ; parameter count
OpenRefNum   ds    2                    ; space for result
OpenPath     dc    i4'PictPath'         ; pointer to pathname
OpenAccess   dc    i2'2'                ; write-only

PictPath     dc    i2'PictEnd-PictStart'
PictStart    dc    c'*:System:Drivers:Screen.'
FileNameSuffix dc  c'a'
PictEnd      anop

CreateParams dc    i2'4'                ; parameter count
             dc    i4'PictPath'
             dc    i2'$00C3'            ; standard access
             dc    i2'$C1'              ; file type
             dc    i4'1'                ; auxiliary type

WriteParams  dc    i2'4'                ; parameter count
WriteRefNum  ds    2                    ; reference number
WriteBuffer  ds    4                    ; pointer to data to write
WriteReqCount ds   4                    ; request count
WriteTrCount ds    4                    ; transfer count

CloseParams  dc    i2'1'
CloseRefNum  ds    2                    ; reference number

MyStatusRec  ds    16                   ; we don't use these 16 bytes
             ds    4                    ; print record handle
             ds    4                    ; printing grafPort
             ds    4                    ; hPic

GFIParams    dc    i2'2'                ; just two parameters
             dc    i4'PictPath'         ; the pathname
             ds    2                    ; storage for access

LocInfoSpace ds    16                   ; space for the LocInfo record

*****************************************************************************
*
*      Below: dialogdata.aii --
*             Dialog box text and layout and all message strings
*
*       Written by Ben Koning
*       Modified by Matt Deatherage
*       Copyright (C) 1990 Apple Computer, Inc.
*
*****************************************************************************

*
*STATUSWINDOWTEMP: Window template for status box:
*
*                            Export      StatusWindowTemp
StatusWindowTemp   anop
            dc     i2'StatusWindowTempEnd-StatusWindowTemp' ;paramLength Word
            dc     i2'fAlert+fQContent+fVis'      ;wFrameBits Word
            dc     i4'0'                           ;wTitle Pointer
            dc     i4'0'                           ;wRefCon Long
            dc     i2'0,0,0,0'                     ;wZoom  Rect
            dc     i4'0'                           ;wColor
WindColorPtr dc     i2'0'                          ;wYOrigin Integer
            dc     i2'0'                           ;wXOrigin Integer
            dc     i2'200'                         ;wDataH Word
            dc     i2'640'                         ;wDataW Word
            dc     i2'200'                         ;wMaxH Word
            dc     i2'640'                         ;wMaxW Word
            dc     i2'0'                           ;wScrollVer Word
            dc     i2'0'                           ;wScrollHor Word
            dc     i2'0'                           ;wPageVer Word
            dc     i2'0'                           ;wPageHor Word
            dc     i4'0'                           ;wInfoRefCon Long
            dc     i2'0'                           ;wInfoHeight Word
            dc     i4'0'                           ;wFrameDefProc Pointer
            dc     i4'0'                           ;wInfoDefProc Pointer
            dc     i4'0'                           ;wContDefProc Pointer
            dc     i2'20'                          ;wPosition Rect Y1
StatusWindowCoordX1 dc i2'12'                      ;wPosition Rect X1
            dc     i2'20+25'                       ;wPosition Rect Y2
StatusWindowCoordX2 dc i2'308'                     ;wPosition Rect X2
            dc     i4'$FFFFFFFF'                   ;wPlane GrafPortPtr
            dc     i4'0'                           ;wStorage WindRecPtr
StatusWindowTempEnd anop
StatusWindowTextY dc i2'15'

*
*MANFEEDALERTTEMP: Alert template for manual feed status dialog:
*
ManFeedAlertTemp dc i2'20'                        ;boundsRect Y1
ManFeedAlertTempCoordX1 dc i2'12'                 ;boundsRect X1
                        dc i2'20+50'              ;boundsRect Y2
ManFeedAlertTempCoordX2 dc i2'308'                ;boundsRect X2
            dc     i2'mesgFeedPromptID'           ;alertID
            dc     i1'$80'                        ;stage 1 - no beep
            dc     i1'$80'                        ;stage 2 - no beep
            dc     i1'$80'                        ;stage 3 - no beep
            dc     i1'$80'                        ;stage 4 - no beep
            dc     i4'ManFeedAlertTempOKButtItem' ;item #1
            dc     i4'ManFeedAlertTempNGButtItem' ;item #2
            dc     i4'ManFeedAlertTempStringItem' ;item #3
            dc     i4'0'                          ;terminator

ManFeedAlertTempOKButtItem dc i2'mesgFeedPromptOKButtID'    ;itemID
            dc     i2'28,180,0,0'                 ;coords
            dc     i2'buttonItem'                 ;itemType
            dc     i4'ManFeedAlertTempOKButtStr'  ;itemDescriptor
            dc     i2'0'                          ;itemValue
            dc     i2'0'                          ;itemFlag
            dc     i4'0'                          ;itemColor
ManFeedAlertTempOKButtStr str 'Continue' 

ManFeedAlertTempNGButtItem dc i2'mesgFeedPromptNGButtID' ;itemID
            dc     i2'28,85,0,0'                  ;coords
            dc     i2'buttonItem'                 ;itemType
            dc     i4'ManFeedAlertTempNGButtStr'  ;itemDescriptor
            dc     i2'0'                          ;itemValue
            dc     i2'0'                          ;itemFlag
            dc     i4'0'                          ;itemColor
ManFeedAlertTempNGButtStr str 'Cancel'

ManFeedAlertTempStringItem dc i2'mesgFeedPromptStringID' ;itemID
            dc     i2'9,84,200,640'               ;coords
            dc     i2'statText+itemDisable'       ;itemType/disabled
            dc     i4'ManFeedAlertTempStringStr'  ;itemDescriptor
            dc     i2'0'                          ;itemValue
            dc     i2'0'                          ;itemFlag
            dc     i4'0'                          ;itemColor
ManFeedAlertTempStringStr dc i1'ManFeedAlertTempStrE-ManFeedAlertTempStrB'
ManFeedAlertTempStrB dc c'Insert sheet for page: '
ManFeedAlertTempPageNo dc c'XXXXX'
ManFeedAlertTempStrE ANOP

*
*DEVALERTTEMP: Alert template for if improper device is connected or device
*error:
*
DevAlertTemp dc    i2'20'               ;boundsRect Y1
DevAlertTempCoordX1 dc i2'12'           ;boundsRect X1
            dc     i2'20+50'            ;boundsRect Y2
DevAlertTempCoordX2 dc i2'308'          ;boundsRect X2
            dc     i2'notDevPromptID'   ;alertID
            dc     i1'$81'              ;stage 1
            dc     i1'$81'              ;stage 2
            dc     i1'$81'              ;stage 3
            dc     i1'$81'              ;stage 4
            dc     i4'DevAlertTempButtonItem' ;item
            dc     i4'DevAlertTempString1Item' ;item
            dc     i4'DevAlertTempString2Item' ;item
            dc     i4'0'                ;terminator

DevAlertTempButtonItem dc i2'notDevPromptButtonID'  ;itemID
            dc     i2'30,200,0,0'                   ;coords
            dc     i2'buttonItem'                   ;itemType
            dc     i4'DevAlertTempButtonStr'        ;itemDescriptor
            dc     i2'0'                            ;itemValue
            dc     i2'0'                            ;itemFlag
            dc     i4'0'                            ;itemColor
DevAlertTempButtonStr str 'Cancel'

DevAlertTempString1Item dc i2'notDevPromptString1ID' ;itemID
            dc     i2'4,74,4+10,640'                 ;coords
            dc     i2'statText+itemDisable'          ;itemType/disabled
            dc     i4'DevAlertTempString1Str'        ;itemDescriptor
            dc     i2'0'                             ;itemValue
            dc     i2'0'                             ;itemFlag
            dc     i4'0'                             ;itemColor
DevAlertTempString1Str str 'Device not an ImageWriter,'

DevAlertTempString2Item dc i2'notDevPromptString2ID' ;itemID
            dc     i2'15,74,15+10,640'               ;coords
            dc     i2'statText+itemDisable'          ;itemType/disabled
            dc     i4'DevAlertTempString2Str'        ;itemDescriptor
            dc     i2'0'                             ;itemValue
            dc     i2'0'                             ;itemFlag
            dc     i4'0'                             ;itemColor
DevAlertTempString2Str str 'not ready, or out of paper.'

*
*Status messages used in the status box during printing:
*
StMePrinterOpenMesg   str  'Establishing communication' ; during PrinterOpen
StMePrinterResetMesg  str 'Positioning print head'      ; during PrinterReset
StMeFirstProgressMesg str 'Preparing to receive page data' ;first mesg in box
StMeSpoolProgressMesg str 'Recording data for page: XXXXX' ; MUST be 30 chars!
StMeDraftProgressMesg str 'Currently printing page: XXXXX' ; MUST be 30 chars!
StMeSheetsLeftMesg    str 'Sheets  left  to  print: XXXXX' ; MUST be 30 chars!
StMeMallocMesg        str 'Allocating imaging memory'    ; getting bandbuff
StMeRenderingMesg     str 'Rendering page image'         ; during DrawPicture
StMeCancellingMesg    str 'Cancelling'                   ; during abort ops
StMeCommunicationMesg str 'Printer communications error' ; for if status error
StMeOutOfPaperMesg    str 'Printer is out of paper'      ; for if status error
StMePaperJamMesg      str 'Printer paper is jammed'      ; for if status error
StMeCoverOpenMesg     str 'Printer cover is open'        ; for if status error
StMeSelectOffMesg     str 'Printer select is off'        ; for if status error
StMeInUseMesg         str 'Printer is in use'            ; for if status error

*
*WINDOWTEMP: Window template for both of our dialogs (we just make the
*controls fit one size box):
*
WindowTemp   dc    i2'WindowTempEnd-WindowTemp'        ;paramLength Word
             dc    i2'fAlert+fQContent+fVis'           ;wFrameBits Word
             dc    i4'0'                               ;wTitle Pointer
             dc    i4'0'                               ;wRefCon Long
             dc    i2'0,0,0,0'                         ;wZoom  Rect
             dc    i4'0'                               ;wColor WindColorPtr
             dc    i2'0'                               ;wYOrigin Integer
             dc    i2'0'                               ;wXOrigin Integer
             dc    i2'200'                             ;wDataH Word
             dc    i2'640'                             ;wDataW Word
             dc    i2'200'                             ;wMaxH Word
             dc    i2'640'                             ;wMaxW Word
             dc    i2'0'                               ;wScrollVer Word
             dc    i2'0'                               ;wScrollHor Word
             dc    i2'0'                               ;wPageVer Word
             dc     i2'0'                              ;wPageHor Word
             dc     i4'0'                              ;wInfoRefCon Long
             dc     i2'0'                              ;wInfoHeight Word
             dc     i4'0'                              ;wFrameDefProc Pointer
             dc     i4'0'                              ;wInfoDefProc Pointer
             dc     i4'0'                              ;wContDefProc Pointer
             dc     i2'20'                             ;wPosition Rect Y1
WindowCoordX1 dc   i2'12'                              ;wPosition Rect X1
             dc    i2'180'                             ;wPosition Rect Y2
WindowCoordX2 dc   i2'308'                             ;wPosition Rect X2
            dc     i4'$FFFFFFFF'                       ;wPlane GrafPortPtr
            dc     i4'0'                               ;wStorage WindRecPtr
WindowTempEnd anop

*
*Coordinates for adornment line separating title/version info from controls
*in the dialog boxes:
*
WindowLineY gequ     14
WindowLineX1 gequ     7
WindowLineX2 gequ   287

*
*STYLECONTROLTEMP: Control templates for the style dialog window for
*PrStlDialog call:
*
StyleControlTemp dc i4'orientationLandscapeItem'
             dc    i4'orientationPortraitItem'
            dc     i4'orientationTitleItem'
            dc     i4'effectsCondensedItem'
            dc     i4'effectsNoGapsItem'
            dc     i4'effectsTitle1Item'
            dc     i4'reductionItem'
            dc     i4'paperTypeItem'
            dc     i4'titleItem'        ;these are common
            dc     i4'versionItem'      ;items, shared by
            dc     i4'cancelItem'       ;the other dialog
            dc     i4'okItem'           ;boxes
            dc     i4'0'

titleItem   dc     i2'8'                ;pCount
            dc     i4'titleItemID'      ;ID
            dc     i2'3,6,13,258'       ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'TiItStart'        ;TextRef
PortTitleLen dc    i2'PortTitleLenOrig' ;space for len byte
TiItStart   dc     c'Picter/'
TiItEnd     anop
PortTitleStr dc    c'XXXXXXXXXXXXXXX'   ;space for portname
PortTitleLenOrig equ TiItEnd-TiItStart  ;for computations

versionItem dc     i2'8'                ;pCount
            dc     i4'versionItemID'    ;ID
            dc     i2'3,258,13,298'     ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'VeTiStart'        ;TitleRef
            dc     i2'VeTiEnd-VeTiStart' ;Use "VersionID"...
VeTiStart   dc     c'v'                  ;...equate to...
            dc     i1'($30+(OurVersion/256))' ;...generate code...
            dc     c'.'                 ;...for version...
            dc     i1'($30+OurVersion)' ;...string
VeTiEnd     anop

cancelItem  dc     i2'9'                ;pCount
            dc     i4'cancelItemID'     ;ID
            dc     i2'128,220,128+11,284'  ;Rect
            dc     i4'simpleButtonControl' ;ProcRef
            dc     i2'0'                ;Flags
            dc     i2'$3000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title'            ;TitleRef
            dc     i4'0'                ;ColorTableRef
            dc     i1'cancelItemKeyEquiv' ;KeyEquiv
            dc     i1'cancelItemKeyEquiv'
            dc     i2'0'
            dc     i2'0'
Title       str    'Cancel'
cancelItemKeyEquiv equ 27               ;escape key equiv

okItem      dc     i2'9'                ;pCount
            dc     i4'okItemID'         ;ID
            dc     i2'143,220,143+11,284'    ;Rect
            dc     i4'simpleButtonControl'   ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$3000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title2'           ;TitleRef
            dc     i4'0'                ;ColorTableRef
            dc     i1'okItemKeyEquiv'   ;KeyEquiv
            dc     i1'okItemKeyEquiv'   ;KeyEquiv
            dc     i2'0'
            dc     i2'0'
Title2      str    'OK'                 ; not "ok" or "Ok" or "Okay"
okItemKeyEquiv equ 13                   ;return key equiv

paperTypeItem dc   i2'9'                ;pCount
            dc     i4'paperTypeItemID'  ;ID
            dc     i2'28,7,0,0'         ;Rect
            dc     i4'popUpControl'     ;ProcRef
            dc     i2'32'               ;Flags
            dc     i2'$1004'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'92'               ;TitleWidth
            dc     i4'paperTypePopUpMenu'    ;MenuRef
paperTypeInitValue dc i2'paperTypeScreenItemID'   ;InitialValue

paperTypePopUpMenu dc c'$$Paper Type:\H'
            dc     i2'paperTypeItemID'
            dc     i1'0'
*                           
            dc     c'--Apple IIgs Screen size\H'
            dc     i2'paperTypeScreenItemID'
            dc     i1'0'
*
            dc     c'--US Letter......8.5"x11"\H'
            dc     i2'paperTypeUsaLtrItemID'
            dc     i1'0'
*                           
*
            dc     c'.'

reductionItem dc   i2'9'                ;pCount
            dc     i4'reductionItemID'  ;ID
            dc     i2'53,7,0,0'         ;Rect
            dc     i4'popUpControl'     ;ProcRef
            dc     i2'32'               ;Flags
            dc     i2'$1004'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'92'               ;TitleWidth
            dc     i4'reductionPopUpMenu' ;MenuRef
reductionInitValue dc i2'reductionFullSizeItemID' ;InitialValue
reductionPopUpMenu dc c'$$Reduction:\H'
            dc     i2'reductionItemID'
            dc     i1'0'
            dc     c'--Full Size\H'
            dc     i2'reductionFullSizeItemID'
            dc     i1'0'
            dc     c'--50% Life Size\DH'
            dc     i2'reduction50ItemID'
            dc     i1'0'
            dc     c'.'

effectsTitle1Item dc i2'8'              ;pCount
            dc     i4'effectsTitle1ItemID'   ;ID
            dc     i2'78,7,78+10,7+60'  ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title2Start'      ;TitleRef
            dc     i2'Title2End-Title2Start' ;TextSize
Title2Start dc     c'Height:'
Title2End   anop

effectsNoGapsItem dc i2'8'              ;pCount
            dc     i4'effectsNoGapsItemID' ;ID
            dc     i2'78,99,0,0'        ;Rect
            dc     i4'checkControl'     ;ProcRef
            dc     i2'0'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'effectsNoGapsTitle'    ;TitleRef
effectsNoGapsInitValue dc i2'0'         ;InitialValue
effectsNoGapsTitle str 'No Vertical Gaps'

effectsCondensedItem dc i2'8'           ;pCount
            dc     i4'effectsCondensedItemID'     ;ID
            dc     i2'91,99,0,0'        ;Rect
            dc     i4'checkControl'     ;ProcRef
            dc     i2'0'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'effectsCondensedTitle' ;TitleRef
effectsCondensedInitValue dc i2'0'      ;InitialValue
effectsCondensedTitle str 'Vertical Condense'

orientationTitleItem dc i2'8'           ;pCount
            dc     i4'orientationTitleItemID'     ;ID
            dc     i2'110,7,110+10,7+90'     ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title3Start'      ;TitleRef
            dc     i2'Title3End-Title3Start' ;TextSize
Title3Start dc     c'Orientation:'
Title3End    anop

orientationPortraitItem dc i2'7'        ;pCount
            dc     i4'orientationPortraitItemID'  ;ID
orientationPortraitRect dc i2'123+0,20+0,123+32,20+72' ;Rect
            dc     i4'iconButtonControl'     ;ProcRef
            dc     i2'2'                ;Flags
            dc     i2'$9000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'portraitIcon'     ;IconRef
portraitIcon dc    i2'0'                ;iconType
            dc     i2'325'              ;iconSize
            dc     i2'25'               ;iconHeight
            dc     i2'26'               ;iconWidth
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$00,$00,$00,$0F,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$F0,$0F,$FF,$0F,$0F,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$0F,$F0,$FF,$0F,$F0,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$0F,$F0,$FF,$00,$00,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$F0,$0F,$FF,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$F0,$0F,$F0,$0F,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$0F,$FF,$FF,$F0,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$0F,$0F,$F0,$F0,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$0F,$0F,$F0,$F0,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$0F,$0F,$F0,$F0,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$0F,$0F,$F0,$F0,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$F0'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$F0'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$F0'
            dc     i1'$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$F0,$00'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF'
*Icon Mask                          
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'

orientationLandscapeItem dc i2'7'       ;pCount
            dc     i4'orientationLandscapeItemID' ;ID
orientationLandscapeRect dc i2'123+0,98+0,123+32,98+72'     ;Rect
            dc     i4'iconButtonControl'     ;ProcRef
            dc     i2'2'                ;Flags
            dc     i2'$9000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'landscapeIcon'    ;IconRef
landscapeIcon dc   i2'0'                ;iconType
            dc     i2'325'              ;iconSize
            dc     i2'25'               ;iconHeight
            dc     i2'26'               ;iconWidth
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$00,$00,$00,$0F,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$FF,$FF,$0F,$0F,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$00,$FF,$FF,$0F,$F0,$FF,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$0F,$FF,$00,$00,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$FF,$0F,$00,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$F0,$FF,$0F,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$F0,$FF,$0F,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$FF,$0F,$00,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$0F,$FF,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$FF,$F0,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$0F,$FF,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$F0'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$F0'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$F0'
            dc     i1'$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$F0,$00'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$0F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$FF'
            dc     i1'$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF'
*Icon Mask                          
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'
            dc     i1'$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF'

*
*JOBCONTROLTEMP: Control templates for the job dialog window for PrJobDialog
*call:
*
JobControlTemp dc  i4'pageFeedItem'
            dc     i4'chromaItem'
            dc     i4'printQualityItem'
            dc     i4'pagesToBoxItem'
            dc     i4'pagesToTitleItem'
            dc     i4'pagesFromBoxItem'
            dc     i4'pagesFromTitleItem'
            dc     i4'pagesRangeItem'
            dc     i4'pagesAllItem'
            dc     i4'pagesTitleItem'
            dc     i4'copiesBoxItem'
            dc     i4'copiesTitleItem'
            dc     i4'titleItem'        ;use same title,
            dc     i4'versionItem'      ;version, cancel
            dc     i4'cancelItem'       ;and ok items as...
            dc     i4'okItem'           ;the other dialog
            dc     i4'0'

printQualityItem dc i2'9'
            dc     i4'printQualityItemID'    ;ID
            dc     i2'95,7,0,0'         ;Rect
            dc     i4'popUpControl'     ;ProcRef
            dc     i2'32'               ;Flags
            dc     i2'$1004'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'92'               ;TitleWidth
            dc     i4'printQualityPopUpMenu' ;MenuRef
printQualityInitValue dc i2'printQualityStandardItemID'
printQualityPopUpMenu dc c'$$Quality:\H'
            dc     i2'printQualityItemID'
            dc     i1'0'
            dc     c'--Standard\H'
            dc     i2'printQualityStandardItemID'
            dc     i1'0'
            dc     c'--Best\DH'
            dc     i2'printQualityBetterItemID'
            dc     i1'0'
            dc     c'.'

chromaItem  dc     i2'9'                ;pCount
            dc     i4'chromaItemID'     ;ID
            dc     i2'110,7,0,0'        ;Rect
            dc     i4'popUpControl'     ;ProcRef
            dc     i2'32'               ;Flags
            dc     i2'$1004'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'92'               ;TitleWidth
            dc     i4'chromaPopUpMenu'  ;MenuRef
chromaInitValue dc i2'chromaMonochromeItemID'     ;InitialValue
chromaPopUpMenu dc c'$$Chroma:\H'
            dc     i2'chromaItemID'
            dc     i1'0'
            dc     c'--Black/White\DH'
            dc     i2'chromaMonochromeItemID'
            dc     i1'0'
            dc     c'--Color\H'
            dc     i2'chromaColorItemID'
            dc     i1'0'
            dc     c'.'

pageFeedItem dc    i2'9'                ;pCount
            dc     i4'pageFeedItemID'   ;ID
            dc     i2'131,7,0,0'        ;Rect
            dc     i4'popUpControl'     ;ProcRef
            dc     i2'32'               ;Flags
            dc     i2'$1004'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'92'               ;TitleWidth
            dc     i4'pageFeedPopUpMenu'     ;MenuRef
pageFeedInitValue dc i2'pageFeedAutoItemID'  ;InitialValue
pageFeedPopUpMenu dc c'$$Sheet Feed:\H'
            dc     i2'pageFeedItemID'
            dc     i1'0'
            dc     c'--Automatic\H'
            dc     i2'pageFeedAutoItemID'
            dc     i1'0'
            dc     c'--Manual\H'
            dc     i2'pageFeedManualItemID'
            dc     i1'0'
            dc     c'.'

pagesTitleItem dc  i2'8'                ;pCount
            dc     i4'pagesTitleItemID' ;ID
            dc     i2'47,7,47+12,7+50'  ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title4Start'      ;TitleRef
            dc     i2'Title4End-Title4Start' ;TextSize
Title4Start dc     c'Pages:'
Title4End   anop

pagesAllItem dc    i2'8'                ;pCount
            dc     i4'pagesAllItemID'   ;ID
            dc     i2'47,99,47+12,99+20' ;Rect
            dc     i4'radioControl'     ;ProcRef
            dc     i2'0'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'pagesAllTitle'    ;TitleRef
pagesAllInitValue dc i2'0'              ;InitialValue
pagesAllTitle str  'All'

pagesRangeItem dc  i2'8'                ;pCount
            dc     i4'pagesRangeItemID' ;ID
            dc     i2'47,164,47+12,164+36'   ;Rect
            dc     i4'radioControl'     ;ProcRef
            dc     i2'0'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'pagesRangeTitle'  ;TitleRef
pagesRangeInitValue dc i2'0'            ;InitialValue
pagesRangeTitle str 'Range'

pagesFromTitleItem dc i2'8'             ;pCount
            dc     i4'pagesFromTitleItemID'  ;ID
            dc     i2'61,58,61+12,58+36'     ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title5Start'      ;TitleRef
            dc     i2'Title5End-Title5Start' ;TextSize
Title5Start dc     c'From'
Title5End   anop

pagesFromBoxItem dc i2'8'               ;pCount
            dc     i4'pagesFromBoxItemID'    ;ID
            dc     i2'60,99,60+13,99+57'     ;Rect
            dc     i4'$83000000'        ;"lineEditControl"
            dc     i2'0'                ;Flags
            dc     i2'$7000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'5'                ;MaxSize
            dc     i4'pagesFromBoxString'    ;DefaultRef
pagesFromBoxString str 'XXXXX'

pagesToTitleItem dc i2'8'               ;pCount
            dc     i4'pagesToTitleItemID'    ;ID
            dc     i2'75,58,75+12,58+20'     ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title6Start'      ;TitleRef
            dc     i2'Title6End-Title6Start' ;TextSize
Title6Start dc     c'To'
Title6End   anop

pagesToBoxItem dc  i2'8'                ;pCount
            dc     i4'pagesToBoxItemID' ;ID
            dc     i2'74,99,74+13,99+57'     ;Rect
            dc     i4'$83000000'        ;"lineEditControl"
            dc     i2'0'                ;Flags
            dc     i2'$7000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'5'                ;MaxSize
            dc     i4'pagesToBoxString' ;DefaultRef
pagesToBoxString str 'XXXXX'

copiesTitleItem dc i2'8'                ;pCount
            dc     i4'copiesTitleItemID'     ;ID
            dc     i2'28,7,28+12,7+50'  ;Rect
            dc     i4'statTextControl'  ;ProcRef
            dc     i2'1'                ;Flags
            dc     i2'$1000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i4'Title7Start'      ;TitleRef
            dc     i2'Title7End-Title7Start' ;TextSize
Title7Start dc     c'Copies:'
Title7End   anop

copiesBoxItem dc   i2'8'                ;pCount
            dc     i4'copiesBoxItemID'  ;ID
            dc     i2'27,99,27+13,99+57'     ;Rect
            dc     i4'$83000000'        ;PR: lineEditControl
            dc     i2'0'                ;Flags
            dc     i2'$7000'            ;MoreFlags
            dc     i4'0'                ;RefCon
            dc     i2'5'                ;MaxSize
            dc     i4'copiesBoxString'  ;DefaultRef
copiesBoxString str 'XXXXX'

*
*DATA: Maintains status message box's window grafport, size, and status
*across print driver calls:
*
StatusWindowPtr    dc i4'0'
StatusWindowWidth  dc i2'0'
StatusWindowExists dc i2'0'             ;must be 0 initially

*
*DATA: Extended task record used by dialogs into which TaskMaster dumps data
*and gets parameters:
*
DialogTaskRecord anop
DialogWhat  dc     i2'0'
DialogMessage dc   i4'0'
DialogWhen  dc     i4'0'
DialogWhere dc     i2'0,0'
DialogModifiers dc i2'0'
DialogTaskData dc  i4'0'
DialogTaskMask dc  i4'DialogTaskMaskYesKeys'
DialogLastClickTick dc i4'0'
DialogClickCount dc i2'0'
DialogTaskData2 dc i4'0'
DialogTaskData3 dc i4'0'
DialogTaskData4 dc i4'0'
DialogLastClickPt dc i2'0,0'
*                          ;10987654321098765432109876543210
DialogTaskMaskYesKeys equ  %00000000000100110000000000000100
DialogTaskMaskNoKeys equ   %00000000000100010000000000000100

PrOpenDocMsg str   'Doing PrOpenDoc'
PrOpenPageMsg str  'Doing PrOpenPage'
PrClosePageMsg str 'Doing PrClosePage'
PrPicFileMsg str   'Doing PrPicFile'

             END
